<?php
#alertenotifications.php
session_start();
include('db_connection.php');  // Votre fichier de connexion à la base de données

// Vérifiez si l'utilisateur est connecté
if (!isset($_SESSION['id'])) {
    echo json_encode(['error' => 'Utilisateur non connecté']);
    exit;
}

$userId = $_SESSION['id'];

// Récupérer le nombre de notifications non lues
$queryCount = $bdd->prepare("SELECT COUNT(*) FROM DaliooNotifications WHERE IDUSER = ? AND Statut = 1");
$queryCount->execute([$userId]);
$notificationCount = $queryCount->fetchColumn();

// Récupérer les notifications non lues
$queryNotifications = $bdd->prepare("SELECT * FROM DaliooNotifications WHERE IDUSER = ? AND Statut = 1 ORDER BY Date DESC");
$queryNotifications->execute([$userId]);

$notifications = [];
while ($row = $queryNotifications->fetch(PDO::FETCH_ASSOC)) {
    $notifications[] = [
        'ID' => $row['ID'],
        'Titre' => $row['Titre'],
        'Description' => $row['Description'],
        'Date' => $row['Date'],
        'Statut' => $row['Statut']
    ];
}

// Retourner le nombre de notifications et les notifications
echo json_encode([
    'count' => $notificationCount,
    'notifications' => $notifications
]);
?>
