
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Widevine DRM instantiation example</title>

    <script src="https://reference.dashif.org/dash.js/latest/dist/dash.all.debug.js"></script>

    <!-- Bootstrap core CSS -->
    <link href="https://reference.dashif.org/dash.js/latest/samples/lib/bootstrap/bootstrap.min.css" rel="stylesheet">
    <link href="https://reference.dashif.org/dash.js/latest/samples/lib/main.css" rel="stylesheet">

    <style>
        video {
            width: 640px;
            height: 360px;
        }
    </style>

    <script class="code">
        function init() {
            var protData = {
                "com.widevine.alpha": {
                    "serverURL": "https://lic.drmtoday.com/license-proxy-widevine/cenc/?specConform=true",
                    "httpRequestHeaders": {
                        "x-dt-auth-token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzUxMiJ9.eyJjcnQiOiJbe1wiYWNjb3VudGluZ0lkXCI6XCJkaWdpdGFsdmlyZ29cIixcImFzc2V0SWRcIjpcImdhbGF4eV8yMjM0NDU2XCIsXCJwcm9maWxlXCI6e1wicmVudGFsXCI6e1wiYWJzb2x1dGVFeHBpcmF0aW9uXCI6XCIyMDIyLTA4LTExVDE4OjI1OjIyLjAwMFpcIixcInBsYXlEdXJhdGlvblwiOjE3MjgwMDAwMH19LFwib3V0cHV0UHJvdGVjdGlvblwiOntcImRpZ2l0YWxcIjp0cnVlLFwiYW5hbG9ndWVcIjp0cnVlLFwiZW5mb3JjZVwiOmZhbHNlfSxcInN0b3JlTGljZW5zZVwiOnRydWV9XSIsIm9wdERhdGEiOiJ7XCJ1c2VySWRcIjpcInNtYXJ0dmlkZW9cIixcIm1lcmNoYW50XCI6XCJkaWdpdGFsdmlyZ29cIixcInNlc3Npb25JZFwiOlwiOTZkZDg0NzYtMmMyMy00MDRmLThjYzgtN2JiZmMxOGFmMGJlXCJ9IiwiaWF0IjoxNjYwMDYyMzIyLCJqdGkiOiJjNmNiNTFjNC03MTg4LTQyZjAtOTg2MC1mOTNlYTY5Y2RiMzYiLCJleHAiOjE2NjAwNjU5MjJ9.uJOsOocOfIP63gJO8REtLJ3RbFOig0c5Mz3iarYBzFHqKD316SbAbb7IG3AU3USE9LnoiTHbsgAjTAc_Nocmjg"
                    },
                    priority: 0
                }
            };
            var video,
                player,
                url = "https://smartvideo-delivd.galaxydve.com/usp/5047-6958_2234456/stream.ism/dash.mpd";

            video = document.querySelector("video");
            player = dashjs.MediaPlayer().create();
            player.initialize(video, url, true);
            player.setProtectionData(protData);
        }

        function check() {
            if (location.protocol === 'http:' && location.hostname !== 'localhost') {
                var out = 'This page has been loaded under http. This might result in the EME APIs not being available to the player and any DRM-protected content will fail to play. ' +
                    'If you wish to test manifest URLs that require EME support, then <a href=\'https:' + window.location.href.substring(window.location.protocol.length) + '\'>reload this page under https</a>.'
                var div = document.getElementById('http-warning');
                div.innerHTML = out;
                div.style.display = ''
            }
        }
    </script>
</head>
<body>

<main>
    <div class="container py-4">
        <header class="pb-3 mb-4 border-bottom">
            <img class=""
                 src="../lib/img/dashjs-logo.png"
                 width="200">
        </header>
        <div class="row">
            <div class="col-md-12">
                <div class="alert alert-danger" role="alert" style="display: none" id="http-warning">

                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="h-100 p-5 bg-light border rounded-3">
                    <h3>Widevine DRM instantiation example</h3>
                    <p>This example shows how to use dash.js to play streams with Widevine DRM protection. </p>
                    <p>For a detailed explanation on DRM playback in dash.js checkout the
                        <a href="https://github.com/Dash-Industry-Forum/dash.js/wiki/Digital-Rights-Management-(DRM)-and-license-acquisition"
                           target="_blank">Wiki</a>.</p>
                </div>
            </div>
            <div class="col-md-8">
                <video controls="true"></video>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div id="code-output"></div>
            </div>
        </div>
        <footer class="pt-3 mt-4 text-muted border-top">
            &copy; DASH-IF
        </footer>
    </div>
</main>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        check();
        init();
    });
</script>
<script src="https://reference.dashif.org/dash.js/latest/samples/highlighter.js"></script>
</body>
</html>
