
<!DOCTYPE html>
<html lang="fr">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"><!-- End Required meta tags -->
    <!-- Begin SEO tag -->
    <title> Connectez-vous dans votre compte </title>
    <meta property="og:title" content="Connectez-vous dans votre compte">
    <meta name="author" content="FYATU">
    <meta property="og:locale" content="fr">
    <meta name="description" content="Meilleure plateforme pour acheter des cartes bancaires virtuelles, retirer de l'argent depuis PayPal, transférer de l'argent sans frais et recharger les numéros de téléphones dans plus de 170 pays.">
    <meta property="og:description" content="Meilleure plateforme pour acheter des cartes bancaires virtuelles, retirer de l'argent depuis PayPal, transférer de l'argent sans frais et recharger les numéros de téléphones dans plus de 170 pays.">
    <link rel="canonical" href="https://fyatu.com/login">
    <meta property="og:url" content="https://fyatu.com">
    <meta property="og:site_name" content="FYATU">
    <!-- Favicons -->
    <link rel="apple-touch-icon" sizes="144x144" href="/account/apple-touch-icon.png">
    <link rel="shortcut icon" href="/favicon.ico">
    <meta name="theme-color" content="#95137b"><!-- Google font -->
    <link href="https://fonts.googleapis.com/css?family=Fira+Sans:400,500,600" rel="stylesheet"><!-- End Google font -->
    <!-- BEGIN PLUGINS STYLES -->
    <link rel="stylesheet" href="https://fyatu.com/account/vendor/open-iconic/font/css/open-iconic-bootstrap.min.css">
    <link rel="stylesheet" href="https://fyatu.com/account/vendor/@fortawesome/fontawesome-free/css/all.min.css"><!-- END PLUGINS STYLES -->
    <!-- BEGIN THEME STYLES -->
    <link rel="stylesheet" href="https://fyatu.com/account/stylesheets/theme.min.css" data-skin="default">
    <link rel="stylesheet" href="https://fyatu.com/account/stylesheets/theme-dark.min.css" data-skin="dark">
    <link rel="stylesheet" href="https://fyatu.com/account/stylesheets/custom.css">
    <link href="https://fyatu.com/assets/css/countrySelect.css" rel="stylesheet">
    <link href="https://fyatu.com/assets/css/intlTelInput.css" rel="stylesheet">
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-H9WKMSYRJK"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-H9WKMSYRJK');
    </script>
    <!-- Start Alexa Certify Javascript -->
    <script type="text/javascript">
        _atrk_opts = { atrk_acct:"dJjAw1Y1Mn20Io", domain:"fyatu.com",dynamic: true};
        (function() { var as = document.createElement('script'); as.type = 'text/javascript'; as.async = true; as.src = "https://certify-js.alexametrics.com/atrk.js"; var s = document.getElementsByTagName('script')[0];s.parentNode.insertBefore(as, s); })();
    </script>
    <noscript><img src="https://certify.alexametrics.com/atrk.gif?account=dJjAw1Y1Mn20Io" style="display:none" height="1" width="1" alt="" /></noscript>
    <!-- End Alexa Certify Javascript -->
    <script>
        var skin = localStorage.getItem('skin') || 'default';
        var disabledSkinStylesheet = document.querySelector('link[data-skin]:not([data-skin="' + skin + '"])');
        // Disable unused skin immediately
        disabledSkinStylesheet.setAttribute('rel', '');
        disabledSkinStylesheet.setAttribute('disabled', true);
        // add loading class to html immediately
        document.querySelector('html').classList.add('loading');
    </script><!-- END THEME STYLES -->
</head>
<body>
<!--[if lt IE 10]>
<div class="page-message" role="alert">You are using an <strong>outdated</strong> browser. Please <a class="alert-link" href="http://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</div>
<![endif]-->
<!-- .auth -->
<main class="auth">
    <header id="auth-header" class="auth-header">
        <a href="/">
            <img alt="Fyatu" src="\new\img\brand\logo.png" width="250px" id="navbar-logo">
        </a>
        <p> N'avez-vous pas un compte ? <a href="/register">Ouvrir Un Compte</a>
        </p>
    </header><!-- form -->
    <div class="auth-form was-validated">
        <!-- .form-group -->
        <div class="form-group">
            <div class="form-label-group">
                <input type="email" id="email" class="form-control" maxlength="50" placeholder="Email" autofocus="" required>
                <label for="email">Email</label>
                <div class="invalid-feedback">Adresse email Invalide </div>
            </div>
        </div>

        <div class="form-group">
            <div class="form-label-group">
                <input type="password" id="password" class="form-control" maxlength="50" placeholder="Mot de Passe" minlength="8" required>
                <label for="password">Mot de Passe</label>
                <div class="invalid-feedback">Mot de passe invalide </div>
            </div>
        </div>
                    <div class="g-recaptcha mb-2" data-callback="callback" data-sitekey="6LeDiL4ZAAAAANtEGWL2vaFrur7xfGASsv97uM36"></div>
                <!-- .form-group -->
        <div class="form-group">
            <button class="btn btn-lg btn-primary btn-block" type="submit" id="btnLogin">Connexion</button>
        </div>
        <!-- recovery links -->
        <div class="text-center pt-3">
            <a href="/register" class="link">Créer Un Compte</a> <span class="mx-2">·</span> <a href="/auth/forgot" class="link">Réinitialiser Mot de Passe</a>
        </div><!-- /recovery links -->
    </div>

    <footer class="auth-footer"> © 2022 Tous droits réservés. <a href="#">Conditions d'utilisation</a>
    </footer>
</main>
<!-- /.auth -->
<!-- BEGIN BASE JS -->
<script src="https://fyatu.com/account/vendor/jquery/jquery.min.js"></script>
<script src="https://fyatu.com/account/vendor/popper.js/umd/popper.min.js"></script>
<script src="https://fyatu.com/account/vendor/bootstrap/js/bootstrap.min.js"></script>
<!-- END BASE JS -->
<script src="https://fyatu.com/account/vendor/pace-progress/pace.min.js"></script>
<script src="https://fyatu.com/account/vendor/stacked-menu/js/stacked-menu.min.js"></script>
<script src="https://fyatu.com/account/vendor/parsleyjs/parsley.min.js"></script>
<!-- BEGIN PLUGINS JS -->
<script src="https://fyatu.com/account/vendor/particles.js/particles.js"></script>
<script src="https://fyatu.com/assets/js/countrySelect.js"></script>
<script src="https://fyatu.com/assets/js/datepicker.js"></script>
<script src="https://fyatu.com/assets/js/authScripts.js"></script>
<script src="https://fyatu.com/assets/js/intlTelInput.js"></script>
<script src="https://fyatu.com/assets/js/intlTelInput-jquery.js"></script>
<script>
    $("#country").countrySelect();
    $("#mobile-number").intlTelInput({
        utilsScript: "/assets/js/utils.js",
        nationalMode:false,
        separateDialCode:true,
        initialCountry: "auto",
        geoIpLookup: function(callback) {
            $.get('https://ipinfo.io', function() {}, "jsonp").always(function(resp) {
                var countryCode = (resp && resp.country) ? resp.country : "us";
                callback(countryCode);
            });
        },
    });
</script>
<script>
    /**
     * Keep in mind that your scripts may not always be executed after the theme is completely ready,
     * you might need to observe the `theme:load` event to make sure your scripts are executed after the theme is ready.
     */
    $(document).on('theme:init', () =>
    {
        /* particlesJS.load(@dom-id, @path-json, @callback (optional)); */
        particlesJS.load('auth-header', '/account/javascript/pages/particles.json');
    })
</script> <!-- END PLUGINS JS -->
<!-- BEGIN THEME JS -->
<script src="/account/javascript/theme.js"></script> <!-- END THEME JS -->

</body>
</html>
