<div class="vod-container">
    <?php
    // Préparation et exécution de la requête pour obtenir les VOD classées par genre
    $Listes_Vod = $bdd->prepare("SELECT * FROM VOD ORDER BY `genre` ASC");
    $Listes_Vod->execute();

    // Stockage des VOD dans un tableau organisé par genre
    $vodParGenre = [];
    while ($Listes = $Listes_Vod->fetch()) {
        $genre = $Listes['genre'];
        if (!isset($vodParGenre[$genre])) {
            $vodParGenre[$genre] = [];
        }
        $vodParGenre[$genre][] = $Listes;
    }

    // Affichage des VOD par genre
    foreach ($vodParGenre as $genre => $vods) {
        echo "<h2 class='genre-title'>" . htmlspecialchars($genre) . "</h2>";
        echo "<div class='row genre-rowx'>";

        foreach ($vods as $vod) {
            ?>
            <div class="col-6 col-md-4 col-lg-3 mb-3">
                <a href="index.php?vod=<?= $vod['id']; ?>" class="vod-card">
                    <div class="card bg-dark">
                        <div class="card-img">
                            <img src="<?= $vod['image']; ?>" class="img-fluid vod-image">
                            <div class="overlay">
                                <span class="play-button">▶</span>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
            <?php
        }

        echo "</div>"; // Fin de la ligne de genre
    }
    ?>
</div>