<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Plateforme CCO</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            padding: 20px;
        }
        .navbar {
            margin-bottom: 20px;
        }
        .search-bar {
            margin-bottom: 20px;
        }
        .movie-card {
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            background-color: #fff;
            cursor: pointer;
        }
        .movie-card img {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
        }
        .json-display {
            background-color: #282c34;
            color: #61dafb;
            padding: 10px;
            border-radius: 8px;
            white-space: pre-wrap;
            font-family: monospace;
        }
        .movie-details {
            margin-top: 20px;
            padding: 20px;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
        <div class="container-fluid">
            <a class="navbar-brand" href="#">Plateforme CCO</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" aria-current="page" href="#">Accueil</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#LinkMovieDetails">Contenus</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#LinkJson">Paramètres</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Search Bar -->
    <div class="container search-bar">
        <div class="input-group mb-3">
            <input type="text" id="searchInput" class="form-control" placeholder="Rechercher des contenus..." aria-label="Search" aria-describedby="button-addon2">
            <button class="btn btn-outline-secondary" type="button" id="searchButton">Rechercher</button>
        </div>
    </div>

    <!-- Movies Section -->
    <div class="container">
        <h2>Résultats des Contenus</h2>
        <div id="movies" class="row"></div>
    </div>

    <!-- Movie Details Section -->
    <div class="container mt-5" id="LinkMovieDetails">
        <h3>Détails du Film</h3>
        <div id="movieDetails" class="movie-details"></div>
    </div>

    <!-- JSON Display Section -->
    <div class="container mt-5" id="LinkJson">
        <h3>Affichage JSON Beautifié</h3>
        <pre class="json-display" id="jsonDisplay"></pre>
    </div>

    <!-- Bootstrap JS and Popper.js -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Script principal -->
    <script>
        /// Fonction pour générer un nombre aléatoire
        function generateRandomNumber(min, max) {
            return Math.floor(Math.random() * (max - min + 1)) + min;
        }

        // Configuration de l'API
        const randomNumber = generateRandomNumber(1, 5);
        const API_URL = `https://api.themoviedb.org/3/movie/popular?language=fr-FR&page=${randomNumber}`;
        const API_KEY = "eyJhbGciOiJIUzI1NiJ9.eyJhdWQiOiI5MTU1OGY0NDcxMDA0YTUwYTIyZmQ1OGRkZDBlODVmNyIsIm5iZiI6MTczODg5MDAxMS4yMDg5OTk5LCJzdWIiOiI2N2E1NWIxYjRkYzA1MmJhNTU4NWQ2OGIiLCJzY29wZXMiOlsiYXBpX3JlYWQiXSwidmVyc2lvbiI6MX0.DpcwfUZsWWiPWYv_nTzABDE76HjStpBArLM_55Omkkk.";

        // Fonction pour récupérer et afficher les films populaires
        async function fetchMovies() {
            //const API_URL = `https://api.themoviedb.org/3/movie/popular?language=fr-FR&page=1`;
            try {
                const response = await fetch(API_URL, {
                    headers: {
                        "Authorization": `Bearer ${API_KEY}`,
                        "Accept": "application/json"
                    }
                });
                if (!response.ok) {
                    throw new Error("Erreur lors de la récupération des films");
                }
                const data = await response.json();
                displayMovies(data.results);
                document.getElementById("jsonDisplay").textContent = JSON.stringify(data.results, null, 2);
            } catch (error) {
                console.error("Erreur :", error);
                document.getElementById("movies").innerHTML = "<p>Impossible de charger les films.</p>";
            }
        }

        // Fonction pour rechercher des films par mot-clé
        async function searchMovies(query) {
            const searchUrl = `https://api.themoviedb.org/3/search/movie?query=${encodeURIComponent(query)}&include_adult=false&language=fr-FR&page=1`;
            try {
                const response = await fetch(searchUrl, {
                    headers: {
                        "Authorization": `Bearer ${API_KEY}`,
                        "Accept": "application/json"
                    }
                });
                if (!response.ok) {
                    throw new Error("Erreur lors de la recherche des films");
                }
                const data = await response.json();
                displayMovies(data.results);
                document.getElementById("jsonDisplay").textContent = JSON.stringify(data.results, null, 2);
            } catch (error) {
                console.error("Erreur :", error);
                document.getElementById("movies").innerHTML = "<p>Aucun résultat trouvé.</p>";
            }
        }

        // Fonction pour afficher les films
        function displayMovies(movies) {
            const moviesContainer = document.getElementById("movies");
            moviesContainer.innerHTML = ""; // Clear previous results

            if (movies.length === 0) {
                moviesContainer.innerHTML = "<p>Aucun film trouvé.</p>";
                return;
            }

            movies.forEach(movie => {
                const movieCard = `
                    <div class="col-md-4" data-movie-id="${movie.id}">
                        <div class="movie-card">
                            <img src="https://image.tmdb.org/t/p/w500${movie.poster_path}" alt="${movie.title}">
                            <h5>${movie.title}</h5>
                            <p>${movie.overview.substring(0, 100)}...</p>
                        </div>
                    </div>
                `;
                moviesContainer.innerHTML += movieCard;
            });

            // Ajouter un écouteur d'événements pour chaque carte de film
            document.querySelectorAll('[data-movie-id]').forEach(card => {
                card.addEventListener('click', () => {
                    const movieId = card.getAttribute('data-movie-id');
                    fetchMovieDetails(movieId);
                });
            });
        }

        // Fonction pour récupérer les détails d'un film
        async function fetchMovieDetails(movieId) {
            const detailsUrl = `https://api.themoviedb.org/3/movie/${movieId}?language=en-US`;
            try {
                const response = await fetch(detailsUrl, {
                    headers: {
                        "Authorization": `Bearer ${API_KEY}`,
                        "Accept": "application/json"
                    }
                });
                if (!response.ok) {
                    throw new Error("Erreur lors de la récupération des détails du film");
                }
                const data = await response.json();
                displayMovieDetails(data);
            } catch (error) {
                console.error("Erreur :", error);
                document.getElementById("movieDetails").innerHTML = "<p>Impossible de charger les détails du film.</p>";
            }
        }

        // Fonction pour afficher les détails du film
        function displayMovieDetails(movie) {
            const detailsContainer = document.getElementById("movieDetails");
            detailsContainer.innerHTML = `
                <h4>${movie.title}</h4>
                <p><strong>Date de sortie :</strong> ${movie.release_date}</p>
                <p><strong>Note :</strong> ${movie.vote_average}/10</p>
                <p><strong>Synopsis :</strong> ${movie.overview}</p>
                <p><strong>Budget :</strong> $${movie.budget.toLocaleString()}</p>
                <p><strong>Revenus :</strong> $${movie.revenue.toLocaleString()}</p>
            `;
        }

        // Événement pour le bouton de recherche
        document.getElementById("searchButton").addEventListener("click", () => {
            const query = document.getElementById("searchInput").value.trim();
            if (query) {
                searchMovies(query);
            } else {
                alert("Veuillez entrer un terme de recherche.");
            }
        });

        // Charger les films populaires au démarrage
        fetchMovies();
    </script>
</body>
</html>